app.controller("network", ["wifi", "bluetooth", "system", "$scope", "$location", "$interval",

    function(wifi, bluetooth, system, $scope, $location, $interval) {
        // Scope variable declaration
        // Wifi configuration
        $scope.wifi_connect              = false;
        $scope.scan_results              = [];
        $scope.selected_cell             = null;
        $scope.scan_running              = false;
        $scope.connected                 = false;
        $scope.connected_cell            = null;
        $scope.show_passprompt           = false;
        $scope.wifi_ip                   = "";
        $scope.connect_wifi              = {};
        $scope.saved_wifis               = [];
        // LAN configuration
        $scope.lan_ip                    = "";

        // Scope filter definitions
        $scope.orderScanResults = function(cell) {
            return parseInt(cell.signal_strength);
        }

        // Scope function definitions
        $scope.wifi_rescan = function() {
            $scope.scan_results = [];
            $scope.scan_running = true;
            wifi.rescan_wifi().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.scan_results = response.data.scan_results;
                }
                $scope.scan_running = false;
            });
        }

        $scope.change_selection = function(cell) {
            $scope.selected_cell = cell;
            $scope.connect_wifi = {
				wifi_ssid: cell["ssid"]
			};
            $scope.show_passprompt = (cell != null) ? true : false;
        }

        $scope.submit_selection = function() {
            if (!$scope.selected_cell) return;
            $scope.show_passprompt = false;

			console.log("wifi_ssid", $scope.connect_wifi.wifi_ssid);
			console.log("wifi_passcode", $scope.connect_wifi.wifi_passcode);
			wifi.enable_wifi($scope.connect_wifi).then(function(response) {
				if (response.data.status == "SUCCESS") {
					console.log("WiFi Enabled");
					$scope.connected = true;
					$scope.connected_cell = $scope.selected_cell;
				} else {
					$scope.connected = false;
					$scope.connected_cell = null;
				}
			});

        }

        $scope.update_wifi_info = function() {
            wifi.get_wifi_info().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("WIFI SSID: " + response.data.ap_ssid);
                    console.log("WIFI AP Address: " + response.data.ap_addr);
                    $scope.connected_cell = {
                        "ssid": response.data.ap_ssid,
                        "address": response.data.ap_addr
                    };
                    $scope.selected_cell = $scope.connected_cell;
                }
            });
        }

        $scope.is_wifi_enabled = function() {
            wifi.is_wifi_enabled().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    if (response.data.connected && response.data.address != '192.168.42.1') {
                        console.log("WIFI is Connected");
                        console.log("WIFI IPv4: " + response.data.address);
                        $scope.connected = true;
                        $scope.wifi_ip = response.data.address;
                        $scope.update_wifi_info();
                    } else {
                        console.log("WIFI is not Connected");
                        $scope.connected = false;
                    }
                }
            });
        }

        $scope.wifi_reboot = function() {
            wifi.reboot_wifi().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("WiFi rebooted");
                    $scope.is_wifi_enabled();
                }
            });
        }

        $scope.get_saved_wifis = function() {
            wifi.list_saved_wifis().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.saved_wifis = response.data.known_wifis;
                }
            });
        }

        $scope.wifi_enable = function() {
            wifi.enable_wifi().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("WiFi enabled");
                    $scope.is_wifi_enabled();
                }
            });
        }

        $scope.wifi_disable = function() {
            wifi.disable_wifi().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("WIFI disabled");
                    $scope.wifi_ip = response.data.address;
                    $scope.connected_cell = null;
                }
            });
        }

        $scope.wifi_remove_known = function(ssid) {
			$scope.saved_wifis = $scope.saved_wifis.filter(function( obj ) {
				return obj.ssid !== ssid;
			});
        }

        $scope.wifi_forget_known = function() {
            wifi.forget_saved_wifi().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("Known WIFIs forgotten");
                }
            });
        }

        $scope.is_lan_connected = function() {
            system.is_lan_connected().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    if (response.data.connected) {
                        console.log("LAN is Connected");
                        console.log("LAN IPv4: " + response.data.address);
                        $scope.connected = true;
                        $scope.lan_ip = response.data.address;
                    } else {
                        console.log("LAN is not Connected");
                        if (!$scope.wifi_ip) {
                            $scope.connected = false;
                        }
                    }
                }
            });
        }

        // Defer load the states and infos
        $scope.is_wifi_enabled();
        $scope.is_lan_connected();
        $scope.wifi_rescan();
		$scope.get_saved_wifis();
        $interval(function() {
            $scope.is_wifi_enabled();
            $scope.is_lan_connected();
        }, 5000);

    }]
);
