app.controller("piratenbox", ["piratenbox", "$scope", "$location", "$interval",

    function(piratenbox, $scope, $location, $interval) {

        $scope.port                   = 4242;
        $scope.status                 = false;
        $scope.enabled                = false;
        $scope.active                 = false;

        $scope.stop = function() {
            $scope.status = "stopping";
            piratenbox.stop().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("PiratenBox gestopped: " + response.data.result);
                    $scope.active = false;
                    $scope.status = "stopped";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.restart = function() {
            $scope.status = "restarting";
            piratenbox.restart().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("PiratenBox neugestartet: " + response.data.result);
                    $scope.active = true;
                    $scope.status = "started";
                } else {
                    $scope.status = "failed_restart";
                }
            });
        }

        $scope.enable = function() {
            $scope.status = "enabling";
            piratenbox.enable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("PiratenBox aktiviert: " + response.data.result);
                    $scope.enabled = true;
                    $scope.status = "enabled";
                } else {
                    $scope.status = "failed_start";
                }
            });
        }

        $scope.disable = function() {
            $scope.status = "disabling";
            piratenbox.disable().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("PiratenBox deaktiviert: " + response.data.result);
                    $scope.enabled = false;
                    $scope.status = "disabled";
                } else {
                    $scope.status = "failed";
                }
            });
        }

        $scope.is_enabled = function() {
            piratenbox.is_enabled().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.enabled = response.data.result;
                }
            });
        }

        $scope.is_active = function() {
            piratenbox.is_active().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.active = response.data.result;
                }
            });
        }

        $scope.get_port = function() {
            piratenbox.get_port().then(function(response) {
                if (response.data.status == "SUCCESS") {
                    $scope.url = response.data.port;
                }
            });
        }

        $scope.set_port = function() {
            piratenbox.set_port({port:$scope.port}).then(function(response) {
                if (response.data.status == "SUCCESS") {
                    console.log("PiratenBox Port geändert: " + response.data.result);
                }
            });
        }

        $scope.is_enabled();
        $scope.is_active();
        $scope.get_port();
        $interval(function() {
            $scope.is_enabled();
            $scope.is_active();
        }, 5000);

    }]
);
