/*****************************************************************************\
    Directive to show / hide / clear the password prompt
\*****************************************************************************/
app.directive("passprompt", function($timeout) {
    return {
        restrict: "E",

        scope: {
            visible:  "=",
            passcode: "=",
            reset:    "&",
            submit:   "&",
        },

        replace: true,          // Use provided template (as opposed to static
                                // content that the modal scope might define in the
                                // DOM)
        template: [
            "<div class='modal fade' ng-class='{ \"in show\": visible }' tabindex='-1' role='dialog' aria-labelledby='passwordLabel' aria-hidden='true'>",
            "    <div class='modal-dialog'>",
            "        <div class='modal-content'>",
            "            <div class='modal-header'>",
            "                <button type='button' class='close' ng-click='reset(null)' aria-hidden='true'>&times;</button>",
            "                <h4 class='modal-title' id='passwordLabel'>Passcode</h4>",
            "            </div>",
            "            <div class='modal-body'>",
            "                <input type='password' class='form-control col-md-3' placeholder='Passcode...' ng-model='passcode' />",
            "            </div>",
            "            <div class='modal-footer'>",
            "                <div class='bootstrap-dialog-footer'>",
            "                    <div class='bootstrap-dialog-footer-buttons'>",
            "                        <button class='btn btn-default' ng-click='reset(null)'>Abbrechen</button>",
            "                        <button class='btn btn-primary' ng-click='submit()'>Verbinden</button>",
            "                    </div>",
            "                </div>",
            "            </div>",
            "        </div>",
            "    </div>",
            "</div>"
        ].join("\n"),

        // Link function to bind modal to the app
        link: function(scope, element, attributes) {
        },
    };
});