"use strict";

/*****************************************************************************\
    Service to hit the rpi bluetooth config server
\*****************************************************************************/
app.service("bluetooth", ["$http", "$location",

    function($http, $location) {
        return {

            is_installed: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/is_installed");
            },

            block: function(hostname) {
                if (!hostname) hostname = $location.host();
				return $http.get("http://" + hostname + ":4242/api/bluetooth/block");
            },
            unblock: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/unblock");
            },
            is_blocked: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/is_blocked");
            },

            enable: function(hostname) {
                if (!hostname) hostname = $location.host();
				return $http.get("http://" + hostname + ":4242/api/bluetooth/enable");
            },
            disable: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/disable");
            },
            is_enabled: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/is_enabled");
            },

            start: function(hostname) {
                if (!hostname) hostname = $location.host();
				return $http.get("http://" + hostname + ":4242/api/bluetooth/start");
            },
            stop: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/stop");
            },
            restart: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/restart");
            },
            is_active: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/is_active");
            },

            is_available: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/is_available");
            },

            is_ready: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/is_ready");
            },

            is_discoverable: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/discoverable");
            },
            set_discoverable: function(value, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/bluetooth/discoverable",{"value":value});
            },

            is_powered: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/powered");
            },
            set_powered: function(value, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/bluetooth/powered",{"value":value});
            },
            reset: function(hostname) {
                if (!hostname) hostname = $location.host();
				return $http.get("http://" + hostname + ":4242/api/bluetooth/reset");
            },

            is_pairable: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/pairable");
            },
            set_pairable: function(value, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/bluetooth/pairable",{"value":value});
            },

            is_scanning: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/scanning");
            },
            set_scanning: function(value, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/bluetooth/scanning",{"value":value});
            },

            pair: function(value, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/bluetooth/pair",{"value":value});
            },
            unpair: function(value, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/bluetooth/unpair",{"value":value});
            },
            is_confirming: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/is_confirming");
            },
            is_waiting_for_pin: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/is_waiting_for_pin");
            },
            get_pin: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/pin");
            },

            connect: function(value, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/bluetooth/connect",{"value":value});
            },
            disconnect: function(value, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/bluetooth/disconnect",{"value":value});
            },

            get_controllers: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/controllers");
            },
            get_scanned_devices: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/scanned_devices");
            },
            get_paired_devices: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/paired_devices");
            },
            get_trusted_devices: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/trusted_devices");
            },
            get_blocked_devices: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/blocked_devices");
            },
            get_connected_devices: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/bluetooth/connected_devices");
            },

        };
    }]

);