"use strict";

app.service("screen", ["$http", "$location",

    function($http, $location) {
        return {

            is_on: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/screen/on");
            },
            set_on: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/screen/on", {});
            },
            set_off: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/screen/off", {});
            },

            set_monitor_on: function(monitor, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/screen/monitor/on", {"monitor": monitor});
            },
            set_monitor_off: function(monitor, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/screen/monitor/off", {"monitor": monitor});
            },
            set_monitor_resolution: function(monitor, resolution, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/screen/monitor/resolution", {"monitor": monitor, "resolution": resolution});
            },
            set_monitor_rotation: function(monitor, rotation, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/screen/monitor/rotation", {"monitor": monitor, "rotation": rotation});
            },
            set_monitor_position: function(monitor, position, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/screen/monitor/position", {"monitor": monitor, "position": position});
            },
            set_monitor_primary: function(monitor, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/screen/monitor/primary", {"monitor": monitor});
            },
            get_monitors: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/screen/monitors");
            },

            get_blanking: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/screen/blanking");
            },
            set_blanking: function(blanking, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/screen/blanking", {"blanking": blanking});
            },

            get_overscan: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/screen/overscan");
            },
            set_overscan: function(overscan, hostname) {
                if (!hostname) hostname = $location.host();
                return $http.post("http://" + hostname + ":4242/api/screen/overscan", {"overscan": overscan});
            },

        };
    }]

);