"use strict";

/*****************************************************************************\
    Service to hit the rpi wifi config server
\*****************************************************************************/
app.service("wifi", ["$http", "$location",

    function($http, $location) {
        return {

            wlan0_exists: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/wifi/wlan0_exists");
            },
            rescan_wifi: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/wifi/rescan_wifi");
            },
            reboot_wifi: function(hostname) {
                if (!hostname) hostname = $location.host();
				return $http.get("http://" + hostname + ":4242/api/wifi/enable_wifi",{timeout:30000});
            },
            enable_wifi: function(wifi_info, hostname) {
                if (!hostname) hostname = $location.host();
				if (!wifi_info) return $http.get("http://" + hostname + ":4242/api/wifi/enable_wifi",{timeout:30000});
                else return $http.post("http://" + hostname + ":4242/api/wifi/enable_wifi", wifi_info,{timeout:30000});
            },
            disable_wifi: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/wifi/disable_wifi");
            },
            is_wifi_enabled: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/wifi/wifi_connected");
            },
            get_wifi_info: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/wifi/wifi_info",{timeout:3000});
            },
            list_saved_wifis: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.get("http://" + hostname + ":4242/api/wifi/known_wifis");
            },
            forget_saved_wifi: function(hostname) {
                if (!hostname) hostname = $location.host();
                return $http.delete("http://" + hostname + ":4242/api/wifi/known_wifi");
            },

        };
    }]

);