var express           = require('express'),
    router            = express.Router(),
    audio             = require("app/core/audio")(),
    helper            = require("app/core/helper");

router.get("/devices", function(request, response) {
	audio.get_devices(function(error,result) {
		if ( !error && result ) {
			console.log("Got audio devices: " + result);
		}
		helper.apiAnswer({devices:result},error,response);
	});
});

router.get("/soundcards", function(request, response) {
	audio.get_soundcards(function(error,result) {
		if ( !error && result ) {
			console.log("Got soundcards: " + result);
		}
		helper.apiAnswer({soundcards:result},error,response);
	});
});

router.get("/scontrols", function(request, response) {
	audio.get_simple_controls(null, function(error,result) {
		if ( !error && result ) {
			console.log("Got simple controls: " + result);
		}
		helper.apiAnswer({scontrols:result},error,response);
	});
});

router.get("/scontrols/:soundcard", function(request, response) {
	audio.get_simple_controls(request.params.soundcard, function(error,result) {
		if ( !error && result ) {
			console.log("Got simple controls: " + result);
		}
		helper.apiAnswer({scontrols:result},error,response);
	});
});

router.put("/sset", function(request, response) {
	audio.set_simple_control(null, request.body.name, request.body.values, function(error,result) {
		if ( !error && result ) {
			console.log("Set simple control: " + result);
		}
		helper.apiAnswer({scontrols:result},error,response);
	});
});

router.put("/sset/:soundcard", function(request, response) {
	audio.set_simple_control(request.params.soundcard, request.body.name, request.body.values, function(error,result) {
		if ( !error && result ) {
			console.log("Set simple control: " + result);
		}
		helper.apiAnswer({scontrols:result},error,response);
	});
});

router.get("/default/output", function(request, response) {
	audio.get_default_output(function(error,result) {
		if ( !error && result ) {
			console.log("Got default output: " + result.cardName);
		}
		helper.apiAnswer({default_output:result},error,response);
	});
});

router.put("/default/output", function(request, response) {
	console.log("Setting default output to: ", request.body);
	audio.set_default_output(request.body.default_output, function(error,result) {
		if ( !error && result ) {
			console.log("Set default output: " + result);
		}
		helper.apiAnswer({default_output:result},error,response);
	});
});

module.exports = router;