var express           = require('express'),
    router            = express.Router(),
    cors              = require('cors'),
    helper            = require("app/core/helper"),
    bluetooth         = require("app/core/bluetooth")();

router.get("/is_installed", function(request, response) {
	console.log('GET: is_installed');
	bluetooth.is_installed(function(error,result) {
		console.log("Bluetooth is_installed: ", result);
		helper.apiAnswer({result:result},error,response);
	});
});


router.get("/block", function(request, response) {
	console.log('GET: block');
	bluetooth.block(function(error) {
		console.log("Bluetooth blocked");
		helper.apiAnswer({result:"Bluetooth blocked"},error,response);
	});
});
router.get("/unblock", function(request, response) {
	console.log('GET: unblock');
	bluetooth.unblock(function(error) {
		console.log("Bluetooth unblocked");
		helper.apiAnswer({result:"Bluetooth unblocked"},error,response);
	});
});
router.get("/is_blocked", function(request, response) {
	console.log('GET: is_blocked');
	bluetooth.is_blocked(function(error,result) {
		console.log("Bluetooth is_blocked: ", result);
		helper.apiAnswer({result:result},error,response);
	});
});


router.get("/enable", function(request, response) {
	console.log('GET: enable');
	bluetooth.enable(function(error) {
		console.log("Bluetooth enabled");
		helper.apiAnswer({result:"Bluetooth enabled"},error,response);
	});
});
router.get("/disable", function(request, response) {
	console.log('GET: disable');
	bluetooth.disable(function(error) {
		console.log("Bluetooth disabled");
		helper.apiAnswer({result:"Bluetooth disabled"},error,response);
	});
});
router.get("/is_enabled", function(request, response) {
	console.log('GET: is_enabled');
	bluetooth.is_enabled(function(error,result) {
		console.log("Bluetooth is_enabled: ", result);
		helper.apiAnswer({result:result},error,response);
	});
});


router.get("/start", function(request, response) {
	console.log('GET: start');
	bluetooth.start(function(error) {
		console.log("Bluetooth started");
		helper.apiAnswer({result:"Bluetooth started"},error,response);
	});
});
router.get("/stop", function(request, response) {
	console.log('GET: stop');
	bluetooth.stop(function(error) {
		console.log("Bluetooth stopped");
		helper.apiAnswer({result:"Bluetooth stopped"},error,response);
	});
});
router.get("/restart", function(request, response) {
	console.log('GET: restart');
	bluetooth.restart(function(error) {
		console.log("Bluetooth restarted");
		helper.apiAnswer({result:"Bluetooth restarted"},error,response);
	});
});
router.get("/is_active", function(request, response) {
	console.log('GET: is_active');
	bluetooth.is_active(function(error,result) {
		console.log("Bluetooth is_active: ", result);
		helper.apiAnswer({result:result},error,response);
	});
});


router.get("/is_available", function(request, response) {
	console.log('GET: is_available');
	bluetooth.is_available(function(error,result) {
		console.log("Bluetooth is_available: ", result);
		helper.apiAnswer({result:result},error,response);
	});
});


router.get("/is_ready", function(request, response) {
	console.log('GET: is_ready');
	bluetooth.is_ready(function(error,result) {
		console.log("Bluetooth is_ready: ", result);
		helper.apiAnswer({result:result},error,response);
	});
});


router.route("/discoverable")
	.get(function(request, response) {
		console.log('GET: discoverable');
		bluetooth.is_discoverable(function(error,result) {
			console.log("Bluetooth is_discoverable: ", result);
			helper.apiAnswer({result:result},error,response);
		});
	})
	.post(function(request, response) {
		console.log("POST: discoverable");
		if (typeof(request.body.value) != 'undefined') {
			bluetooth.set_discoverable(request.body.value, function(error,result) {
				console.log("Bluetooth discoverable: "+request.body.value);
				helper.apiAnswer({result:"discoverable; "+request.body.value},error,response);
			});
		} else {
			helper.apiAnswer({},"Missing Parameter",response);
		}
	});


router.route("/powered")
	.get(function(request, response) {
		console.log('GET: powered');
		bluetooth.is_powered(function(error,result) {
			console.log("Bluetooth is_powered: ", result);
			helper.apiAnswer({result:result},error,response);
		});
	})
	.post(function(request, response) {
		console.log("POST: powered");
		if (typeof(request.body.value) != 'undefined') {
			bluetooth.set_powered(request.body.value, function(error,result) {
				console.log("Bluetooth powered: "+request.body.value);
				helper.apiAnswer({result:"powered; "+request.body.value},error,response);
			});
		} else {
			helper.apiAnswer({},"Missing Parameter",response);
		}
	});
router.get("/reset", function(request, response) {
	console.log('GET: reset');
	bluetooth.reset(function(error) {
		console.log("Bluetooth reseted");
		helper.apiAnswer({result:"Bluetooth reseted"},error,response);
	});
});


router.route("/pairable")
	.get(function(request, response) {
		console.log('GET: is_pairable');
		bluetooth.is_pairable(function(error,result) {
			console.log("Bluetooth is_pairable: ", result);
			helper.apiAnswer({result:result},error,response);
		});
	})
	.post(function(request, response) {
		console.log("POST: pairable");
		if (typeof(request.body.value) != 'undefined') {
			bluetooth.set_pairable(request.body.value, function(error,result) {
				console.log("Bluetooth pairable: "+request.body.value);
				helper.apiAnswer({result:"pairable; "+request.body.value},error,response);
			});
		} else {
			helper.apiAnswer({},"Missing Parameter",response);
		}
	});


router.route("/scanning")
	.get(function(request, response) {
		console.log('GET: scanning');
		bluetooth.is_scanning(function(error,result) {
			console.log("Bluetooth is_scanning: ", result);
			helper.apiAnswer({result:result},error,response);
		});
	})
	.post(function(request, response) {
		console.log("POST: scanning");
		if (typeof(request.body.value) != 'undefined') {
			bluetooth.set_scanning(request.body.value, function(error,result) {
				console.log("Bluetooth scanning: "+request.body.value);
				helper.apiAnswer({result:"scanning; "+request.body.value},error,response);
			});
		} else {
			helper.apiAnswer({},"Missing Parameter",response);
		}
	});


router.route("/pair")
	.post(function(request, response) {
		console.log("POST: pair");
		if (typeof(request.body.value) != 'undefined') {
			bluetooth.pair(request.body.value, function(error,result) {
				console.log("Bluetooth pair: "+request.body.value);
				helper.apiAnswer({result:"pair; "+request.body.value},error,response);
			});
		} else {
			helper.apiAnswer({},"Missing Parameter",response);
		}
	});
router.route("/unpair")
	.post(function(request, response) {
		console.log("POST: unpair");
		if (typeof(request.body.value) != 'undefined') {
			bluetooth.unpair(request.body.value, function(error,result) {
				console.log("Bluetooth unpair: "+request.body.value);
				helper.apiAnswer({result:"unpair; "+request.body.value},error,response);
			});
		} else {
			helper.apiAnswer({},"Missing Parameter",response);
		}
	});
router.get("/is_confirming", function(request, response) {
	console.log('GET: is_confirming');
	bluetooth.is_confirming(function(error,result) {
		console.log("Bluetooth is_confirming: ", result);
		helper.apiAnswer({result:result},error,response);
	});
});
router.get("/is_waiting_for_pin", function(request, response) {
	console.log('GET: is_waiting_for_pin');
	bluetooth.is_waiting_for_pin(function(error,result) {
		console.log("Bluetooth is_waiting_for_pin: ", result);
		helper.apiAnswer({result:result},error,response);
	});
});
router.get("/pin", function(request, response) {
	console.log('GET: pin');
	bluetooth.get_pin(function(error,result) {
		console.log("Bluetooth pin: ", result);
		helper.apiAnswer({result:result},error,response);
	});
});


router.route("/connect")
	.post(function(request, response) {
		console.log("POST: connect");
		if (typeof(request.body.value) != 'undefined') {
			bluetooth.connect(request.body.value, function(error,result) {
				console.log("Bluetooth connect: "+request.body.value);
				helper.apiAnswer({result:"connect; "+request.body.value},error,response);
			});
		} else {
			helper.apiAnswer({},"Missing Parameter",response);
		}
	});
router.route("/disconnect")
	.post(function(request, response) {
		console.log("POST: disconnect");
		if (typeof(request.body.value) != 'undefined') {
			bluetooth.disconnect(request.body.value, function(error,result) {
				console.log("Bluetooth disconnect: "+request.body.value);
				helper.apiAnswer({result:"disconnect; "+request.body.value},error,response);
			});
		} else {
			helper.apiAnswer({},"Missing Parameter",response);
		}
	});


router.get("/controllers", function(request, response) {
	console.log('GET: controllers');
	bluetooth.get_controllers(function(error,result) {
//		console.log("Bluetooth controllers: ", result);
		helper.apiAnswer({result:result},error,response);
	});
});


router.get("/scanned_devices", function(request, response) {
	console.log('GET: scanned_devices');
	bluetooth.get_scanned_devices(function(error,result) {
//		console.log("Bluetooth scanned devices: ", result);
		helper.apiAnswer({result:result},error,response);
	});
});
router.get("/paired_devices", function(request, response) {
	console.log('GET: paired_devices');
	bluetooth.get_paired_devices(function(error,result) {
//		console.log("Bluetooth paired devices: ", result);
		helper.apiAnswer({result:result},error,response);
	});
});
router.get("/trusted_devices", function(request, response) {
	console.log('GET: trusted_devices');
	bluetooth.get_trusted_devices(function(error,result) {
//		console.log("Bluetooth trusted devices: ", result);
		helper.apiAnswer({result:result},error,response);
	});
});
router.get("/blocked_devices", function(request, response) {
	console.log('GET: blocked_devices');
	bluetooth.get_blocked_devices(function(error,result) {
//		console.log("Bluetooth blocked devices: ", result);
		helper.apiAnswer({result:result},error,response);
	});
});
router.get("/connected_devices", function(request, response) {
	console.log('GET: connected_devices');
	bluetooth.get_connected_devices(function(error,result) {
//		console.log("Bluetooth connected devices: ", result);
		helper.apiAnswer({result:result},error,response);
	});
});

module.exports = router;