var express           = require('express'),
    router            = express.Router(),
    hotspot           = require("app/core/hotspot")(),
    helper            = require("app/core/helper");

router.get("/start", function(request, response) {
	hotspot.start(function(error) {
		console.log("Started Hotspot: " + (!error));
		helper.apiAnswer({result:"Hotspot started"},error,response);
	});
});

router.get("/stop", function(request, response) {
	hotspot.stop(function(error) {
		console.log("Stopped Hotspot: " + (!error));
		helper.apiAnswer({result:"Hotspot stopped"},error,response);
	});
});

router.get("/enable", function(request, response) {
	hotspot.enable(function(error) {
		console.log("Enabled Hotspot: " + (!error));
		helper.apiAnswer({result:"Hotspot enabled"},error,response);
	});
});

router.get("/disable", function(request, response) {
	hotspot.disable(function(error) {
		console.log("Disabled Hotspot: " + (!error));
		helper.apiAnswer({result:"Hotspot disabled"},error,response);
	});
});

router.get("/is_enabled", function(request, response) {
	hotspot.is_enabled(function(error,result) {
		helper.apiAnswer({result:result},error,response);
	});
});

router.get("/is_active", function(request, response) {
	hotspot.is_active(function(error,result) {
		helper.apiAnswer({result:result},error,response);
	});
});

router.post("/set_ssid", function(request, response) {
	hotspot.set_ssid(request.body.ssid,function(error) {
		console.log("Changed Hotspot SSID: " + (!error));
		helper.apiAnswer({result:"Changed Hotspot SSID"},error,response);
	});
});

router.get("/get_ssid", function(request, response) {
	hotspot.get_ssid(function(error,result) {
		if ( !error && result ) {
			console.log("Got Hotspot SSID: " + result);
		}
		helper.apiAnswer({url:result},error,response);
	});
});

router.post("/set_passphrase", function(request, response) {
	hotspot.set_passphrase(request.body.passphrase,function(error) {
		console.log("Changed Hotspot Passphrase: " + (!error));
		helper.apiAnswer({result:"Changed Hotspot Passphrase"},error,response);
	});
});

router.get("/get_passphrase", function(request, response) {
	hotspot.get_passphrase(function(error,result) {
		if ( !error && result ) {
			console.log("Got Hotspot Passphrase: " + result);
		}
		helper.apiAnswer({url:result},error,response);
	});
});

module.exports = router;