var express           = require('express'),
    router            = express.Router(),
    piratenbox        = require("app/core/piratenbox")(),
    helper            = require("app/core/helper");

router.route("/install")
	.post(function(request, response) {
		piratenbox.install(request.body,function(error) {
			console.log("Installed PiratenBox: " + (!error));
			helper.apiAnswer({result:"PiratenBox installed"},error,response);
		});
	});

router.route("/stop")
	.get(function(request, response) {
		piratenbox.stop(function(error) {
			console.log("Stopped PiratenBox: " + (!error));
			helper.apiAnswer({result:"PiratenBox stopped"},error,response);
		});
	});

router.route("/restart")
	.get(function(request, response) {
		piratenbox.restart(function(error) {
			console.log("Restarted PiratenBox: " + (!error));
			helper.apiAnswer({result:"PiratenBox restarted"},error,response);
		});
	});

router.route("/enable")
	.get(function(request, response) {
		piratenbox.enable(function(error) {
			console.log("Enabled PiratenBox: " + (!error));
			helper.apiAnswer({result:"PiratenBox enabled"},error,response);
		});
	});

router.route("/disable")
	.get(function(request, response) {
		piratenbox.disable(function(error) {
			console.log("Disabled PiratenBox: " + (!error));
			helper.apiAnswer({result:"PiratenBox disabled"},error,response);
		});
	});

router.route("/port")
	.get(function(request, response) {
		piratenbox.get_port(function(error,result) {
			console.log("Got PiratenBox port: " + result);
			helper.apiAnswer({port:result},error,response);
		});
	})
	.put(function(request, response) {
		piratenbox.change_port(request.body.port,function(error) {
			console.log("Changed PiratenBox port: " + (!error));
			helper.apiAnswer({result:(!error)},error,response);
		});
	});

router.route("/is_installed")
	.get(function(request, response) {
		piratenbox.is_installed(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_enabled")
	.get(function(request, response) {
		piratenbox.is_enabled(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});

router.route("/is_active")
	.get(function(request, response) {
		piratenbox.is_active(function(error,result) {
			helper.apiAnswer({result:result},error,response);
		});
	});
 
module.exports = router;
