var express           = require('express'),
    router            = express.Router(),
    si                = require('systeminformation'),
    system            = require("app/core/system")(),
    helper            = require("app/core/helper");

router.route("/shutdown")
	.get(function(request, response) {
		console.log('GET: shutdown');
		system.shutdown(function(error) {
			console.log("Shutdown started: " + (!error));
			helper.apiAnswer({result:"Shutdown started"},error,response);
		});
	});

router.route("/reboot")
	.get(function(request, response) {
		console.log('GET: reboot');
		system.reboot(function(error) {
			console.log("Reboot started: " + (!error));
			helper.apiAnswer({result:"Reboot started"},error,response);
		});
	});

router.route("/autoupdate")
	.get(function(request, response) {
		console.log('GET: autoupdate');
		system.autoupdate(function(error) {
			console.log("Autoupdate: " + (!error));
			helper.apiAnswer({result:"Autoupdate started"},error,response);
		});
	});

router.route("/lan_connected")
	.get(function(request, response) {
//        console.log("GET: /lan_connected");
		system.get_lan_info(function(error,result) {
			let response_obj = {connected:(result.inet_addr !== "<unknown>"), address:result.inet_addr};
			helper.apiAnswer(response_obj,error,response);
		})
	});

router.route("/locales")
	.get(function(request, response) {
		console.log('GET: locale');
		system.get_locales(function(error,result) {
			console.log("Got locales: " + (!error));
			helper.apiAnswer({"locales": result},error,response);
		});
	});

router.route("/locale")
	.get(function(request, response) {
		console.log('GET: locale');
		system.get_locale(function(error,result) {
			console.log("Got locale: " + (!error));
			helper.apiAnswer({"locale": result},error,response);
		});
	})
	.post(function(request, response) {
		console.log('POST: locale');
		system.set_locale(request.body,function(error) {
			console.log("Set locale: " + (!error));
			helper.apiAnswer({result:"Locale set"},error,response);
		});
	});

router.route("/keyboard")
	.get(function(request, response) {
		console.log('GET: keyboard');
		system.get_keyboard(function(error,result) {
			console.log("Got keyboard: " + (!error));
			helper.apiAnswer({"keyboard": result},error,response);
		});
	})
	.post(function(request, response) {
		console.log('POST: keyboard');
		system.set_keyboard(request.body,function(error) {
			console.log("Set keyboard: " + (!error));
			helper.apiAnswer({result:"keyboard set"},error,response);
		});
	});


router.route("/temperature")
	.get(function(request, response) {
		console.log('GET: temperature');
		system.get_temperature(function(error,result) {
			console.log("Got temperature: " + (!error));
			helper.apiAnswer({"temperature": result},error,response);
		});
	});

router.route('/system')
	.get(function(request, response) {
		console.log('GET: system');
		system.get_system(function(error,result) {
			console.log("Got system: " + (!error));
			helper.apiAnswer({"system": result},error,response);
		});
	});

router.route('/cpu')
	.get(function(request, response) {
		console.log('GET: cpu');
		system.get_cpu(function(error,result) {
			console.log("Got cpu: " + (!error));
			helper.apiAnswer({"cpu": result},error,response);
		});
	});

router.route('/mem')
	.get(function(request, response) {
		console.log('GET: mem');
		system.get_mem(function(error,result) {
			console.log("Got mem: " + (!error));
			helper.apiAnswer({"mem": result},error,response);
		});
	});

router.route('/graphics')
	.get(function(request, response) {
		console.log('GET: mem');
		system.get_graphics(function(error,result) {
			console.log("Got graphics: " + (!error));
			helper.apiAnswer({"graphics": result},error,response);
		});
	});

router.route('/usb')
	.get(function(request, response) {
		console.log('GET: usb');
		system.get_usb(function(error,result) {
			console.log("Got usb: " + (!error));
			helper.apiAnswer({"usb": result},error,response);
		});
	});

router.route('/disks')
	.get(function(request, response) {
		console.log('GET: disks');
		system.get_disks(function(error,result) {
			console.log("Got disks: " + (!error));
			helper.apiAnswer({"disks": result},error,response);
		});
	});

router.route('/blockdevices')
	.get(function(request, response) {
		console.log('GET: blockdevices');
		system.get_blockdevices(function(error,result) {
			console.log("Got blockdevices: " + (!error));
			helper.apiAnswer({"blockdevices": result},error,response);
		});
	});

router.route('/filesystems')
	.get(function(request, response) {
		console.log('GET: filesystems');
		system.get_filesystems(function(error,result) {
			console.log("Got filesystems: " + (!error));
			helper.apiAnswer({"filesystems": result},error,response);
		});
	});

router.route('/os')
	.get(function(request, response) {
		console.log('GET: os');
		system.get_os(function(error,result) {
			console.log("Got is: " + (!error));
			helper.apiAnswer({"os": result},error,response);
		});
	});

router.route('/uuid')
	.get(function(request, response) {
		console.log('GET: uuid');
		system.get_uuid(function(error,result) {
			console.log("Got uuid: " + (!error));
			helper.apiAnswer({"uuid": result},error,response);
		});
	});

router.route('/users')
	.get(function(request, response) {
		console.log('GET: users');
		system.get_users(function(error,result) {
			console.log("Got users: " + (!error));
			helper.apiAnswer({"users": result},error,response);
		});
	});

router.route('/load')
	.get(function(request, response) {
		console.log('GET: load');
		system.get_load(function(error,result) {
			console.log("Got load: " + (!error));
			helper.apiAnswer({"load": result},error,response);
		});
	});


router.route('/hostname')
	.get(function (request, response) {
		system.get_hostname(function(error, result) {
			console.log("Got hostname: " + (!error));
			helper.apiAnswer({"hostname": result},error,response);
		});
	})
	.post(function (request, response) {
		system.set_hostname(request.body,function(error) {
			console.log("Set hostname: " + (!error));
			helper.apiAnswer({result:"Hostname set"},error,response);
		});
	});

router.route('/passwd')
	.post(function (request, response) {
		system.change_password(request.body,function(error) {
			console.log("Changed password: " + (!error));
			helper.apiAnswer({result:"password changed"},error,response);
		});
	});
 
module.exports = router;
