var express           = require('express'),
    router            = express.Router(),
    cors              = require('cors'),
    helper            = require("app/core/helper"),
    wifi              = require("app/core/wifi")();

router.get("/rescan_wifi", function(request, response) {
	console.log("GET: /rescan_wifi");
	wifi.scan(function(error, result) {
		helper.apiAnswer(result[0], error, response);
	});
});

router.get("/wifi_info", function(request, response) {
    console.log("GET: /wifi_info");
	wifi.get_wifi_info(function(error,result) {
		helper.apiAnswer(result,error,response);
	});
});

router.route("/enable_wifi")
	.get(function(request, response) {
		console.log("GET: /enable_wifi");
		wifi.enable_wifi_mode({}, function(error) {
			helper.apiAnswer({result:"wifi enabled"},error,response);
		});
	})
	.post(function(request, response) {
		console.log("POST: enable_wifi");
		var conn_info = {
			wifi_ssid:      request.body.wifi_ssid,
			wifi_passcode:  request.body.wifi_passcode,
		};
		if (typeof(request.body.force) != 'undefined') {
			conn_info["force"] = request.body.force;
		} else {
			conn_info["force"] = false;
		}
		// TODO: If wifi did not come up correctly, it should fail
		// currently we ignore ifup failures.
		wifi.enable_wifi_mode(conn_info, function(error) {
			if (error) {
				console.log("Enable Wifi ERROR: " + error);
				console.log("Attempt to re-enable AP mode");
				wifi.enable_ap_mode(config.access_point.ssid, function(error) {
					console.log("... AP mode reset");
				});
			}
			console.log("Wifi Enabled! - Standing by.");
			helper.apiAnswer({result:"Wifi enabled"},error,response);
		});
	});

router.get("/wifi_connected", function(request, response) {
    console.log("GET: /wifi_connected");
	wifi.is_wifi_enabled(function(error,result) {
		let response_obj = {connected:(result !== null), address:result};
		helper.apiAnswer(response_obj,error,response);
	})
})

router.get("/reboot_wifi", function(request, response) {
	console.log('GET: reboot_wifi');
	wifi.reboot_wireless_network("wlan0", false, function(error) {
		console.log("Wifi rebooted");
		helper.apiAnswer({result:"Wifi rebooted"},error,response);
	});
});

router.get("/disable_wifi", function(request, response) {
	console.log('GET: disable_wifi');
	wifi.shutdown_wireless_network("wlan0", function(error) {
		console.log("Wifi disabled");
		helper.apiAnswer({result:"Wifi disabled"},error,response);
	});
});

router.get("/enable_ap", function(request, response) {
	console.log('GET: enable_ap');
	wifi.enable_ap_mode(config.access_point.ssid, function(error) {
		console.log("Starting AP mode: " + error);
		helper.apiAnswer({result:"AP enabled"},error,response);
	});
});

router.get("/wlan0_exists", function(request, response) {
	console.log('GET: wlan0_exists');
	wifi.wireless_interface_exists("wlan0", function(error,result) {
		helper.apiAnswer({exists:result},error,response)
	})
});

router.route('/known_wifis')
	.options(cors(helper.cors_delegate)) // Allow 'preflight' CORS requests.
	.delete(function(request, response) {
		console.log('DELETE: known wifi');
		wifi.forget_saved_wifi(function(error) {
			helper.apiAnswer({},error,response);
		})
	})
	.get(function(request, response) {
		console.log('GET: known_wifi');
		wifi.list_saved_wifi(function(error,result) {
			helper.apiAnswer({known_wifis:result},error,response);
		})
	})
	.patch(function(request, response) {
		console.log('PATCH: known_wifi');
		let arg = request.body;
		wifi.reorder_saved_wifi(arg,function(error, result) {
			let retval = [];
			result.forEach(element => {
				retval.push(element.ssid);
			});
			helper.apiAnswer({known_wifis:retval},error,response);
		})
	});
 
module.exports = router;