/**
 * Created by serkan on 09/12/16.
 */
/**
 * Created by serkan on 29/08/16.
 */
/**
 * Modified by elehobica
 */

exports = module.exports = {};
exports.Bluetooth = function () {
    //sudo usermod -G bluetooth -a pi
    //recommended sudo rpi-update
    //echo -e "connect FC:8F:90:21:12:0C \nquit" | bluetoothctl
    var self = this;

    var events = require('events');
    events.EventEmitter.call(self);
    self.__proto__ = events.EventEmitter.prototype;

    //use ptywe.js
    var pty = require('ptywe.js/lib/pty.js');

    var ransi = require('strip-ansi');

    var term = pty.spawn('bash', [], {
        name: 'xterm-color',
        cols: 100,
        rows: 40,
        cwd: process.env.HOME,
        env: process.env
    });

    var bluetoothEvents = {
        Device: 'DeviceEvent',
        Controller: 'ControllerEvent',
        DeviceSignalLevel: 'DeviceSignalLevel',
        Connected: 'Connected',
        Paired: 'Paired',
        AlreadyScanning: 'AlreadyScanning',
        PassKey: 'PassKey',
        EnterPIN: 'EnterPIN',
        PIN: 'PIN',
    }
    var mydata = "";
    var devices = [];
    var controllers = [];
    var isBluetoothControlExists = false;
    var isBluetoothReady = false;
    var isScanning = false;
    var isPowered = false;
    var isDiscoverable = false;
    var isPairable = false;
    var isConfirmingPassKey = false;
    var isWaitingForPIN = false;

    Object.defineProperty(this, 'isBluetoothControlExists', {
        get: function () {
            return isBluetoothControlExists;
        },
        set: function (value) {
            isBluetoothControlExists = value;
        }
    });

    Object.defineProperty(this, 'isScanning', {
        get: function () {
            return isScanning;
        },
        set: function (value) {
            isScanning = value;
        }
    });
    Object.defineProperty(this, 'isPowered', {
        get: function () {
            return isPowered;
        },
        set: function (value) {
            isPowered = value;
        }
    });
    Object.defineProperty(this, 'isDiscoverable', {
        get: function () {
            return isDiscoverable;
        },
        set: function (value) {
            isDiscoverable = value;
        }
    });
    Object.defineProperty(this, 'isPairable', {
        get: function () {
            return isPairable;
        },
        set: function (value) {
            isPairable = value;
        }
    });
    Object.defineProperty(this, 'isConfirmingPassKey', {
        get: function () {
            return isConfirmingPassKey;
        },
        set: function (value) {
            isConfirmingPassKey = value;
        }
    });
    Object.defineProperty(this, 'isWaitingForPIN', {
        get: function () {
            return isWaitingForPIN;
        },
        set: function (value) {
            isWaitingForPIN = value;
        }
    });
    Object.defineProperty(this, 'isBluetoothReady', {
        get: function () {
            return isBluetoothReady;
        },
        set: function (value) {
            isBluetoothReady = value;
        }
    });
    Object.defineProperty(this, 'devices', {
        get: function () {
            return devices;
        },
        set: function (value) {
            devices = value;
        }
    });
    Object.defineProperty(this, 'controllers', {
        get: function () {
            return controllers;
        },
        set: function (value) {
            controllers = value;
        }
    });
    Object.defineProperty(this, 'bluetoothEvents', {
        get: function () {
            return bluetoothEvents;
        },
        set: function (value) {
            bluetoothEvents = value;
        }
    });

    Object.defineProperty(this, 'term', {
        get: function () {
            return term;
        },
        set: function (value) {
            term = value;
        }
    });

    function checkInfo(obj) {
        if (! obj.isConfirmingPassKey && ! obj.isWaitingForPIN && obj.devices.length > 0) {
            for (i = 0; i < obj.devices.length; i++) {
                if (obj.devices[i].paired == '' && obj.devices[i].trycount < 4) {
                    obj.devices[i].trycount += 1;
                    obj.info(obj.devices[i].mac);
                    console.log('bluetoothctlwe - checking info of ' + obj.devices[i].mac)
                }
            }
			term.write('show\r');
            term.write('paired-devices\r');
            term.write('devices\r');
        }
    }

    var os = require('os');
    if (os.platform() == 'linux') {
        term.write('type bluetoothctl\r');
    }


    term.on('data', function (data) {
        data = ransi(data).replace('[bluetooth]#', '');
        if (data.indexOf('bluetoothctl ist ') !== -1 && data.indexOf('/usr/bin/bluetoothctl') !== -1) {
            isBluetoothControlExists = true
            isBluetoothReady=true;
            console.log('bluetoothctlwe - bluetooth controller exists')
            term.write('bluetoothctl\r');
            term.write('power on\r');
            term.write('agent on\r');
            term.write('list\r');
            term.write('show\r');
            term.write('paired-devices\r');
            term.write('devices\r');
            setInterval(checkInfo, 5000, self)
        }
        checkController(data);
		checkControllerInfo(data);

        checkDeviceInfo(data);
        checkDevice(data);
        var regexsignal = /\[[A-Z]{3,5}\]?\s?Device\s([0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2})\sRSSI:\s-(.+)/gm;
        checkDeviceSignal(regexsignal, data);
        var regexconnected = /\[[A-Z]{3,5}\]?\s?Device\s([0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2})\sConnected:\s([a-z]{2,3})/gm;
        checkDeviceConnected(regexconnected, data);
        var regexpaired = /\[[A-Z]{3,5}\]?\s?Device\s([0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2})\sPaired:\s([a-z]{2,3})/gm;
        checkDevicePaired(regexpaired, data);
        var regextrusted = /\[[A-Z]{3,5}\]?\s?Device\s([0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2})\sTrusted:\s([a-z]{2,3})/gm;
        checkDeviceTrusted(regextrusted, data);
        var regexblocked = /\[[A-Z]{3,5}\]?\s?Device\s([0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2})\sBlocked:\s([a-z]{2,3})/gm;
        checkDeviceBlocked(regexblocked, data);

	    var regexpasskeyconfirmation = /\[agent\] Confirm passkey\s([0-9A-F]+)\s[^:]+:/gm;
        checkPasskeyConfirmation(regexpasskeyconfirmation, data);
        var regexenterpin = /\[agent\] Enter PIN code:/gm; //
        checkEnterPIN(regexenterpin, data);
        var regexpin = /\[agent\] PIN code:\s([0-9A-F]+)/gm; //
        checkPIN(regexpin, data);

        var regexscanon1 = 'Discovery started';
        var regexscanon2 = 'Failed to start discovery: org.bluez.Error.InProgress';
        var regexscanon3 = 'Discovering: yes';
        if (data.indexOf(regexscanon1) !== -1 || data.indexOf(regexscanon2) !== -1 || data.indexOf(regexscanon3) !== -1) isScanning = true;
        var regexscanoff1 = 'Discovery stopped'
        var regexscanoff2 = 'Discovering: no';
        if (data.indexOf(regexscanoff1) !== -1 || data.indexOf(regexscanoff2) !== -1) isScanning = false;

        var regexpoweron1 = 'Changing power on succeeded';
        var regexpoweron2 = 'Powered: yes';
        if (data.indexOf(regexpoweron1) !== -1 || data.indexOf(regexpoweron2) !== -1) isPowered = true;
        var regexpoweroff1 = 'Changing power off succeeded'
        var regexpoweroff2 = 'Powered: no';
        if (data.indexOf(regexpoweroff1) !== -1 || data.indexOf(regexpoweroff2) !== -1) isPowered = false;

        var regexdiscoverableon1 = 'Changing discoverable on succeeded';
        var regexdiscoverableon2 = 'Discoverable: yes';
        if (data.indexOf(regexdiscoverableon1) !== -1 || data.indexOf(regexdiscoverableon2) !== -1) isDiscoverable = true;
        var regexdiscoverableoff1 = 'Changing discoverable off succeeded'
        var regexdiscoverableoff2 = 'Discoverable: no';
        if (data.indexOf(regexdiscoverableoff1) !== -1 || data.indexOf(regexdiscoverableoff2) !== -1) isDiscoverable = false;

        var regexpairableon1 = 'Changing pairable on succeeded';
        var regexpairableon2 = 'Pairable: yes';
        if (data.indexOf(regexpairableon1) !== -1 || data.indexOf(regexpairableon2) !== -1) isPairable = true;
        var regexpairableoff1 = 'Changing pairable off succeeded'
        var regexpairableoff2 = 'Pairable: no';
        if (data.indexOf(regexpairableoff1) !== -1 || data.indexOf(regexpairableoff2) !== -1) isPairable = false;

        var regexpairingsuccessful = 'Pairing successful'
        var regexpairingfailed = 'Failed to pair'
        if (data.indexOf(regexpairingsuccessful) !== -1 || data.indexOf(regexpairingfailed) !== -1) {
			isWaitingForPIN = false;
			self.emit(bluetoothEvents.Paired, devices)
		}

    })


    function checkDeviceBlocked(regstr, data) {
        var m;
        while ((m = regstr.exec(data)) !== null) {
            if (m.index === regstr.lastIndex) {
                regstr.lastIndex++;
            }
            //m[1] - macid
            //m[2] - yes or no
            if (devices.length > 0) {
                for (j = 0; j < devices.length; j++) {
                    if (devices[j].mac == m[1]) {
                        devices[j].blocked = m[2];
                        console.log(m[1] + " blocked " + m[2])
                        self.emit(bluetoothEvents.Device, devices)
                    }
                }
            }
        }
    }

    function checkDevicePaired(regstr, data) {
        var m;
        while ((m = regstr.exec(data)) !== null) {
            if (m.index === regstr.lastIndex) {
                regstr.lastIndex++;
            }
            //m[1] - macid
            //m[2] - yes or no
            if (devices.length > 0) {
                for (j = 0; j < devices.length; j++) {
                    if (devices[j].mac == m[1]) {
                        devices[j].paired = m[2];
                        console.log(m[1] + " paired " + m[2])
                        self.emit(bluetoothEvents.Device, devices)
                    }
                }
            }
        }
    }

    function checkPIN(regstr, data) {
        var m;
        while ((m = regstr.exec(data)) !== null) {
            //m[1] - pin
            self.emit(bluetoothEvents.PIN, m[1])

			isWaitingForPIN = true;
        }
    }

    function checkEnterPIN(regstr, data) {
        var m;
        while ((m = regstr.exec(data)) !== null) {
			//console.log('Enter PIN code');
            self.emit(bluetoothEvents.EnterPIN)

			isWaitingForPIN = true;
        }
    }

    function checkPasskeyConfirmation(regstr, data) {
        var m;
        while ((m = regstr.exec(data)) !== null) {
            if (m.index === regstr.lastIndex) {
                regstr.lastIndex++;
            }
            //m[1] - passkey
			//console.log('Confirm passkey : ' + m[1]);
            self.emit(bluetoothEvents.PassKey, m[1])
			// confirmPasskey(true);

			isConfirmingPassKey = true;
        }
    }

    function checkDeviceTrusted(regstr, data) {
        var m;
        while ((m = regstr.exec(data)) !== null) {
            if (m.index === regstr.lastIndex) {
                regstr.lastIndex++;
            }
            //m[1] - macid
            //m[2] - yes or no
            if (devices.length > 0) {
                for (j = 0; j < devices.length; j++) {
                    if (devices[j].mac == m[1]) {
                        devices[j].trusted = m[2];
                        console.log(m[1] + " trusted " + m[2])
                        self.emit(bluetoothEvents.Device, devices)

                    }
                }
            }
        }
    }

    function checkDeviceConnected(regstr, data) {
        var m;
        while ((m = regstr.exec(data)) !== null) {
            if (m.index === regstr.lastIndex) {
                regstr.lastIndex++;
            }
            //m[1] - macid
            //m[2] - yes or no
            if (devices.length > 0) {
                for (j = 0; j < devices.length; j++) {
                    if (devices[j].mac == m[1]) {
                        devices[j].connected = m[2];
                        console.log(m[1] + " connected " + m[2])
                        self.emit(bluetoothEvents.Device, devices)
                    }
                }
            }
        }
    }

    function checkDeviceSignal(regstr, data) {
        var m;
        while ((m = regstr.exec(data)) !== null) {
            if (m.index === regstr.lastIndex) {
                regstr.lastIndex++;
            }
            //m[1] - macid
            //m[2] - signal Level
            if (devices.length > 0) {
                for (j = 0; j < devices.length; j++) {
                    if (devices[j].mac == m[1]) {
                        devices[j].signal = parseInt(m[2])
                        //console.log('bluetoothctlwe - signal level of:' + m[1] + ' is ' + m[2])
                        self.emit(bluetoothEvents.Device, devices)
                        self.emit(bluetoothEvents.DeviceSignalLevel, devices, m[1], m[2]);
                    }
                }
            }
        }
    }


    function checkDeviceInfo(data) {

        var regstr = /Device ([0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}).+\r?\n?\t?Name: (.+)\r?\n?\t?Alias: (.+)\r?\n?\t?Class: (.+)\r?\n?\t?Icon: (.+)\r?\n?\t?Paired: (.+)\r?\n?\t?Trusted: (.+)\r?\n?\t?Blocked: (.+)\r?\n?\t?Connected: (.+)\r?\n?\t?/gmi;

        while ((m = regstr.exec(data)) !== null) {
            if (m.index === regstr.lastIndex) {
                regstr.lastIndex++;
            }
            //m[1] - macid
            //m[2] - device name
            //m[3] - alias
            //m[4] - Class
            //m[5] - Icon
            //m[6] - paired
            //m[7] - trusted
            //m[8] - blocked
            //m[9] - connected
            if (devices.length > 0) {
                for (j = 0; j < devices.length; j++) {
                    if (devices[j].mac == m[1]) {
                        devices[j].name = m[3]
                        devices[j].class = m[4]
                        devices[j].icon = m[5]
                        devices[j].paired = m[6]
                        devices[j].trusted = m[7]
                        devices[j].blocked = m[8]
                        devices[j].connected = m[9]
                        self.emit(bluetoothEvents.Device, devices)
                        //console.log ('bluetoothctlwe - device info received:' + JSON.stringify(devices[j]))
                    }
                }
            }
        }
    }

    function checkDevice(data) {
		
		var regstr = /(\[[A-Z]{3,5}\])?\s?Device\s([0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2})\s(?!RSSI)(?!Name:)(?!Alias:)(?!Class:)(?!Icon:)(?!Paired:)(?!Trusted:)(?!Blocked:)(?!Connected:)(?!LegacyPairing:)(?!not available)(?!UUIDs:)(?!TxPower:)(?!TxPower is nil)(?!ManufacturerData Key:)(?!ManufacturerData Value:)(?![0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2})(?!\s)(.+)/gm;

        var m;
        while ((m = regstr.exec(data)) !== null) {
            if (m.index === regstr.lastIndex) {
                regstr.lastIndex++;
            }
            //m[1] - [NEW] or [DEL] etc..
            //m[2] - macid
            //m[3] - devicename
            if (m[1] == "[DEL]") {
                //remove from list
                if (devices.length > 0) {
                    for (j = 0; j < devices.length; j++) {
                        if (devices[j].mac == m[2]) {
                            devices.splice(j, 1);
                            console.log('bluetoothctlwe - deleting device ' + m[2])
                        }
                    }
                }
            } else {
                var found = false;
                if (devices.length > 0) {
                    for (j = 0; j < devices.length; j++) {
                        if (devices[j].mac == m[2])found = true;
                        if (devices[j].mac == m[2] && m[1] == "[NEW]")found = false;
                    }
                }
                if (!found) {
                    console.log('bluetoothctlwe - adding device ' + m[2])
                    devices.push({
                        mac: m[2],
                        name: m[3],
                        signal: 0,
                        paired: '',
                        trusted: '',
                        icon: '',
                        class: '',
                        blocked: '',
                        connected: '',
                        trycount: 0
                    });
                }
            }
        }
        if ((regstr.exec(data)) !== null) self.emit(bluetoothEvents.Device, devices)
    }


    function checkControllerInfo(data) {

        var regstr = /Controller ([0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2})(?:.+)?\r?\n?[\t\s]+Name: (.+)\r?\n?[\t\s]+Alias: (.+)\r?\n?[\t\s]+Class: (.+)\r?\n?[\t\s]+Powered: (.+)\r?\n?[\t\s]+Discoverable: (.+)\r?\n?[\t\s]+Pairable: (.+)[\S\s]+Modalias: (.+)\r?\n?[\t\s]+Discovering: (.+)\r?\n?/gmi;

        while ((m = regstr.exec(data)) !== null) {
            if (m.index === regstr.lastIndex) {
                regstr.lastIndex++;
            }
            //m[1] - MAC
            //m[2] - Name
            //m[3] - Alias
            //m[4] - Class
            //m[5] - Powered
            //m[6] - Discoverable
            //m[7] - Pairable
            //m[8] - Modalias
            //m[9] - Discovering
            if (controllers.length > 0) {
                for (j = 0; j < controllers.length; j++) {
                    if (controllers[j].mac == m[1]) {
                        controllers[j].name = m[3]
                        controllers[j].class = m[4]
                        controllers[j].powered = m[5]
                        controllers[j].discoverable = m[6]
                        controllers[j].pairable = m[7]
                        controllers[j].modalias = m[8]
                        controllers[j].discovering = m[9]
                        self.emit(bluetoothEvents.Controller, controllers)
                        //console.log ('bluetoothctlwe - controller info received:' + JSON.stringify(controllers[j]))
                    }
                }
            }
        }
    }

    function checkController(data) {
		
		var regstr = /(\[[A-Z]{3,5}\]\s)?Controller\s([0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2}[\.:-][0-9A-F]{1,2})\s(?!Discovering:\s)(?!Powered:\s)(?!Discoverable:\s)(?!Pairable:\s)(?!Class:\s)(?!\(public\))(.+)/gm;
		
        var m;
        while ((m = regstr.exec(data)) !== null) {
            if (m.index === regstr.lastIndex) {
                regstr.lastIndex++;
            }
            //m[1] - [NEW] or [DEL] etc..
            //m[2] - macid
            //m[3] - controllername
            controllers = [];
            controllers.push({mac: m[2], name: m[3]});
            self.emit(bluetoothEvents.Controller, controllers);
            //console.log('bluetoothctlwe - controller found:' + m[2])
            term.write('power on\r');
            term.write('agent on\r');

        }
    }

}

//region exports

exports.agent = function (start) {
    this.term.write('agent ' + (start ? 'on' : 'off') + '\r');
}

exports.power = function (start) {
    this.term.write('power ' + (start ? 'on' : 'off') + '\r');
}

exports.scan = function (startScan) {
    this.term.write('scan ' + (startScan ? 'on' : 'off') + '\r');
}
exports.pairable = function (canpairable) {
    this.term.write('pairable ' + (canpairable ? 'on' : 'off') + '\r');
}
exports.discoverable = function (candiscoverable) {
    this.term.write('discoverable ' + (candiscoverable ? 'on' : 'off') + '\r');
}


exports.pair = function (macID) {
    this.term.write('pair ' + macID + '\r');
}
exports.confirmPassKey = function (confirm) {
    this.isConfirmingPassKey = false;
    this.term.write(confirm ? 'yes\r' : 'no\r');
}

exports.enterPIN = function (pin) {
    this.isWaitingForPIN = false;
    this.term.write(pin + '\r');
}

exports.trust = function (macID) {
    this.term.write('trust ' + macID + '\r');
}

exports.untrust = function (macID) {
    this.term.write('untrust ' + macID + '\r');
}


exports.block = function (macID) {
    this.term.write('block ' + macID + '\r');
}
exports.unblock = function (macID) {
    this.term.write('unblock ' + macID + '\r');
}


exports.connect = function (macID) {
    this.term.write('connect ' + macID + '\r');
}

exports.disconnect = function (macID) {
    this.term.write('disconnect ' + macID + '\r');
}

exports.remove = function (macID) {
    this.term.write('remove ' + macID + '\r');
}

exports.info = function (macID) {
    this.term.write('info ' + macID + '\r');
}


exports.getPairedDevices = function () {
    this.devices = [];
    this.term.write('paired-devices\r');
}

exports.getDevicesFromController = function () {
    this.devices = [];
    this.term.write('devices\r');
}

exports.checkBluetoothController=function(){
    try{
        var execSync = require("child_process").execSync;
        return !!execSync("type bluetoothctl", {encoding: "utf8"});
    }
    catch(e){
        return false;
    }
}

//endregion
