require('app-module-path/register');

var chromeLauncher      = require('chrome-launcher'),
    wmctrl              = require('window-control'),
    exec                = require("child_process").exec,
    screen              = require("app/core/screen")(),
    config              = require("app/core/config")();
var watcher             = {};


var getWindowList = (callback) => {
	exec(`wmctrl -lp`, {env: {'DISPLAY': ':0.0'}}, (error, stdout, stderr) => {
		if (error) return callback(error);
        if (stderr) return callback(stderr);
        windowStrings = stdout.split('\n');
        windowList = [];
        windowStrings.forEach((windowString) => {
			let windowId = windowString.split(' ')[0];
			let windowPid = windowString.split(' ')[3];
			let windowTitle = windowString.split(' ').slice(4).join(' ').trim();
			windowObject = {id: windowId, pid: windowPid, title: windowTitle};
			if (windowId&&windowPid) windowList.push(windowObject);
        })
		callback(null, windowList);
	});
};

var getWindowByPid = (pid, callback) => {
	if (!pid) return;
	getWindowList(function(error, windowList){
		if (error) return callback(error);
		found = false;
		windowList.forEach((windowObject) => {
			if (windowObject.pid==pid) {
				found = windowObject;
			};
		})
		if (found) {
			return callback(null, found);
		} else {
			return callback('not found');
		}
	});
};

var focusWindow = (id, callback) => {
	exec(`wmctrl -i -a ${id}`, {env: {'DISPLAY': ':0.0'}}, (error, stdout, stderr) => {
		if (error) return callback(error);
		if (stderr) return callback(stderr);
		callback();
	});
};

var startChromeWatcher = (pid, refocus, restartCallback) => {
	watcher[pid] = setInterval(function(){
		console.log('Checking chrome with PID:', pid);
		getWindowByPid(pid, (error, windowObject) => {
			if (error=='not found') {
				console.log("No window found with PID:", pid);
				restartCallback();
			} else if (error) {
				console.log("Unknown ERROR:", error);
				restartCallback();
			} else if (!error && refocus) {
				console.log("Refocus windows with PID:", pid);
				focusWindow(windowObject.id, (error) => {
					if (error) console.log('ERROR', error);
				});
			}
		})
	}, 2000);
};

var stopChromeWatcher = (pid) => {
	clearInterval(watcher[pid]);
	delete watcher[pid];
};

var startChrome = (index, options, refocus) => {
	chromeLauncher.launch(options).then(chrome => {
		console.log('Chrome debugging port running on:', chrome.port);
        config.load(function(error,config) {
            if (error) return callback(error);
            if (!config.kiosk) config.kiosk = {};
			console.log('Saving to instance at index:', index);
            config.kiosk.instances[index].pid = chrome.pid;
            config.kiosk.instances[index].port = chrome.port;
			config.save(config, function(error) {
				if (!error) {
					console.log(`Saved pid and port to config  successfully`);
					setTimeout(function(){
						console.log('Start watching chrome with PID:', chrome.pid);
						startChromeWatcher(chrome.pid, refocus, function(){
							console.log('Stop watching PID', chrome.pid, 'and restart chrome');
							stopChromeWatcher(chrome.pid);
							startChrome(index, options, refocus);
						});
					}, 2000);
				}
			});
        });
	});
};

var loadInstances = () => {
	console.log('Loading instances...');
	config.load(function(error,config) {
		if (error) return callback(error);
		if (!config.kiosk) config.kiosk = {};
		if (!config.kiosk.instances) config.kiosk.instances = {};
		config.kiosk.instances.forEach((instance, index) => {
			console.log('index:', index);
			console.log('Loading monitor info for:', instance.monitor);
			screen.get_monitor(instance.monitor, function(error, monitor) {
				if (!monitor) {
					console.log('No monitor found with name:', instance.monitor);
					return;
				}
				console.log('Starting Chrome on monitor ', instance.monitor, ' in ', instance.mode, ' mode');
				var newFlags = chromeLauncher.Launcher.defaultFlags().filter(flag => flag !== '--mute-audio');
				var refocus = false;
				if (instance.mode == 'fullscreen') {
					newFlags.push('--kiosk');
					newFlags.push('--window-position=' + monitor.position.x + ',' + monitor.position.y);
					newFlags.push('--window-size=' + monitor.width + ',' + monitor.height);
				} else if (instance.mode == 'window') {
					newFlags.push('--app='+instance.url);
					newFlags.push('--window-position=' + monitor.position.x + instance.position.x + ',' + monitor.position.y + instance.position.y);
					newFlags.push('--window-size=' + instance.size.x + ',' + instance.size.y);
					refocus = true;
				}
				startChrome(index, {
					startingUrl: instance.url,
					port: instance.port,
					ignoreDefaultFlags: true,
					chromeFlags: newFlags,
					envVars: {'DISPLAY': ':0.0'}
				}, refocus);
			});
		});
	});
};

loadInstances();
/*
exec(`nitrogen --set-zoom-fill /home/pi/PiratenBox/assets/splash/splash.png`, {env: {'DISPLAY': ':0.0'}}, (error, stdout, stderr) => {
	exec(`xsetroot -solid "#FF8800"`, {env: {'DISPLAY': ':0.0'}}, (error, stdout, stderr) => {
		exec(`xset s noblank`, {env: {'DISPLAY': ':0.0'}}, (error, stdout, stderr) => {
			exec(`xset s off`, {env: {'DISPLAY': ':0.0'}}, (error, stdout, stderr) => {
				exec(`xset -dpms`, {env: {'DISPLAY': ':0.0'}}, (error, stdout, stderr) => {
					loadInstances();
				});
			});
		});
	});
});
*/