require('app-module-path/register');

var async               = require("async"),
    dependency          = require("app/core/dependency")(),
    wifi                = require("app/core/wifi")(),
    system              = require("app/core/system")(),
    config              = require("app/core/config")();

require("./app/server.js")(function(error) {
    if (error) {
        console.log("ERROR: " + error);
    } else {
        console.log("\nHTTP server running...");
    }
});


setTimeout(function() {
    setInterval(function() {
        async.series([

			// 1. Check if we have the required dependencies installed
			function test_deps(next_step) {
				dependency.check_deps({
					"binaries": ["dnsmasq", "hostapd", "iw"],
					"files":    ["/etc/dnsmasq.conf"]
				}, function(error) {
					if (error) console.log(" * Dependency error, did you run `sudo npm run-script provision`?");
					next_step(error);
				});
			},

			// 2. Reload the configuration
			function reload_config(next_step) {
                console.log("hotspot - Reloading config...");
                config.load(function(error, data) {
                    if (!error) {
                        config = data;
                        console.log("hotspot -   Reloaded config successfully");
                    }
                    next_step(error);
                });
            },

			// 3. Check if wifi should be enabled automatically
            function check_autoenable(next_step) {
                console.log("hotspot - Check if wifi is connected...");
				if (config.access_point.autoenable==true) {
					console.log("hotspot -   Accesspoint 'autoenable' enabled - Checking network status");
					next_step();
				} else {
					next_step("hotspot -   Accesspoint 'autoenable' disabled");
				}
            },

			// 4. Check if access point is already enabled
            function check_ap_enabled(next_step) {
                console.log("hotspot - Check if AP is enabled...");
				wifi.is_ap_enabled(function(error, result){
					if (result) {
						next_step("hotspot -   AP is already enabled (" + result + ")");
					} else {
						console.log("hotspot -   AP is not active");
						next_step();
					}
				});
            },

			// 5. Check if lan is enabled / connected
            function check_lan_connected(next_step) {
                console.log("hotspot - Check if LAN is connected...");
				system.get_lan_info(function(error, result) {
					if (result && result.inet_addr && result.inet_addr != "<unknown>") {
						next_step("hotspot -   LAN Connection available (" + result.inet_addr + ")");
					} else {
						console.log("hotspot -   No LAN Connection available");
						next_step();
					}
				});
            },

			// 5. Check if wifi is enabled / connected
            function check_wifi_connected(next_step) {
                console.log("hotspot - Check if WiFi is connected...");
				wifi.is_wifi_enabled(function(error, result){
					if (result) {
						next_step("hotspot -   WiFi Connection available (" + result + ")");
					} else {
						console.log("hotspot -   No WiFi Connection available");
						next_step();
					}
				});
            },

			// 3. Start the access point
			function enable_ap_mode(next_step) {
                console.log("hotspot - Starting AP mode...");
				wifi.enable_ap_mode(config.access_point.ssid, function(error) {
					if (error) {
						next_step("hotspot -   Failed to start AP mode");
					} else {
						console.log("hotspot -   Started AP mode");
						next_step();
					}
				});
            }

        ], function(error){
			if (error) {
				console.error(error);
			}
		});

    }, 60000);
}, 30000);