require('app-module-path/register');

var async               = require("async"),
    exec                = require("child_process").exec,
    dependency          = require("app/core/dependency")(),
    config              = require("app/core/config")();

async.series([

	// 1. Check if we have the required dependencies installed
	function test_deps(next_step) {
		console.log("vnc - Check dependencies...");
		dependency.check_deps({
			"binaries": ["x11vnc", "websockify"],
			"files":    ["/etc/x11vnc.pwd"]
		}, function(error) {
			if (error) console.log("Dependency error, did you properly installed the module?");
			next_step(error);
		});
	},

	// 2. Start processes
	function start_processes(next_step) {

		async.parallel([

			// 2. Start x11vnc
			function start_x11vnc(callback) {

				console.log("vnc - Start x11vnc...");

				var bin = '/usr/bin/x11vnc';
				var logfile = '/var/log/x11vnc.log';
				var authfile = '/etc/x11vnc.pwd';
				var params = ' -auth guess -shared -forever -loop -noxdamage -repeat' +
							 ' -rfbauth ' + authfile +
							 ' -rfbport ' + config.vnc.port +
							 ' -o ' + logfile;
				var cmd = bin + params;

				exec(cmd, {env: {'DISPLAY': ':0.0'}}, (error, stdout, stderr) => {
					if (error) return callback(error);
					if (stderr) return callback(stderr);
					callback();
				});

			},

			// 3. Start websockify
			function start_websockify(callback) {

				console.log("vnc - Start websockify...");

				var bin = '/usr/local/bin/websockify';
				var params = ' 44999 localhost:' + config.vnc.port;
				var cmd = bin + params;

				exec(cmd, {env: {'DISPLAY': ':0.0'}}, (error, stdout, stderr) => {
					if (error) return callback(error);
					if (stderr) return callback(stderr);
					callback();
				});

			}

		]);

	}

], function(error){
	if (error) {
		console.error( 'ERROR: ' + error );
	}
});